	% Minimum-Phase FIR Filter
	clear all
	close all
	clc
	wcT = 0.3*pi; wsT = 0.6*pi; dc = 0.02;	ds = 0.0025;
	AmaxS = 20*log10((1+dc)/(1-dc))
	AminS = 20*log10((1+dc)/ds)
	wT = [wcT wsT];	d = [dc ds];
	N = 12; 
	[hMP, ZerosMP] = MIN_PHASE_LP_FIR(N, wT, d);
	hMP = hMP/sum(abs(hMP))
	
	wT = linspace(0, pi, 2000);		% wT axis 0 to  rad
	HMP = freqz(hMP, 1, wT);		% Frequency response
	Phase = angle(HMP);				% Phase response [rad]
	gd = grpdelay(hMP, 1, wT);		% Group delay [T]
	figure(1)
	%	PLOT4_Mag_PZ_Phase_TG_FIR(wT_axis, wT, d, Mag, hMP, ZerosMP, Phase, gd)
	PLOT_MAG_Z_dB(wT, HMP, pi, 80, 'H')
	
	figure(2)
	subplot('position', [0.1 0.04 0.72 0.42])
	PLOT_IMPULSE_RESPONSE_Z(hMP)
	Z = roots(hMP);				% Zeros of the minimum-phase filter
	%	abs(Z)
	
	ZLP = [];	ZMP = [];	m1 = 1;		m2 = 1;
	for n = 1:length(Z)			
		if abs(Z(n)) < 0.999		% Collect the zeros inside the unit circle 
			ZMP(m1) = Z(n);	m1 = m1+1;
		else						% Collect the zeros on the unit circle
			ZLP(m2) = Z(n);	m2 = m2+1; 
		end
	end
	ZLP'
	ZMP'	
	W = 2^13
	h1 = ZEROS_2_POLY(ZLP);		% Linear-phase impulse response
	h1 = h1/sum(abs(h1))		% Safely scaled output the first stage
	h1 =  round(W*h1)/W	% Quantized coefficients
	h1 = [38 229  686 1327  1816 1816 1327 686 229  38]/8192
	figure(3)
	HLP = freqz(h1, 1, wT);		  
	PLOT_MAG_Z_dB(wT, HLP, pi, 80, 'H_LP')
	
	h2 = ZEROS_2_POLY(ZMP);		% Minimum-phase impulse response
	h = POLYMULT(h2, 2);		% Overall impulse response
	h2 = h2/sum(abs(h))			% Safely scaled second stage
	h2 = round(W*h2)/W	% Quantized coefficients
	h2 = [964   -1709 1140  -283]/8192;
	h = conv(h1, h2);
	h = h/sum(h);
	
	figure(4)
	H = freqz(h, 1, wT);		 	 
	PLOT_MAG_Z_dB(wT, H, pi, 80, 'H')
	poly(ZMP')
	
